<?php
/*
	DevSaver Web Framework
	Copyright (c) 2013-2016 DevSaver. 
	All rights reserved.
		web:  www.devsaver.com
		mail: support@devsaver.com				
*/


class CBlogWidgetTopicList extends CWidget {

	/**
	* description
	*
	* @var type
	*
	* @access type
	*/
	var $meta = array(
		"type"	=> "2",
		"name"	=> "Topic List",
		"module"	=> array(
			"name"	=> "",
			"id"	=> "",
			"type"	=> "",
		)
	);

	
	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function Render($widget) {
		global $_SESS;

		$cnt = max(1, $widget["settings"]["set_items"]);

		switch ($widget["settings"]["set_type"]) {
			//latest
			case "1":
				$order = "item_date DESC";
			break;

			//most viewed
			case "2":
				$order = "item_set_views DESC , item_date DESC";
			break;
		}
		

		$items = $this->db->QFetchRowArray(
			"SELECT * FROM 
				{$this->tables['plugin:blog_topics']} as t , 
				{$this->tables['plugin:blog_topics_lang']} as l ,
				{$this->tables['plugin:blog_authors']} as a , 
				{$this->tables['plugin:blog_authors_lang']} as al 

			WHERE 
				t.item_author=a.author_id AND 
				a.author_id = al.author_id AND 
				al.lang_id = l.lang_id AND 
				t.module_id = {$widget[mod_id]} AND 
				l.lang_id={$widget[lang_id]} AND 
				t.item_id=l.item_id AND
				t.item_status = 1 AND 
				t.item_date <= " . time() . " 
				" . ( $_SESS["client"] ? "" : " AND item_protect=0 ") . "

			ORDER BY {$order}
			LIMIT $cnt
			"
		);

		if (is_array($items)) {

			global $base;

			foreach ($items as $key => $val) {

				$val["image"] = $this->plugins["media"]->GetThumb($val["item_id"] , $val["module_id"] , array("path" => "upload/blog"));

				$items[$key]["image"] = $this->tpl->blockReplace($val["image"] ? "Photo" : "NoPhoto" , $val);

				$items[$key]["link"] = $widget["link"] . $val["item_url"] . "/" . $val["item_id"] ;

				$items[$key]["item_brief"] = $val["item_brief"] = strip_tags($val["item_brief"]);

				if (strlen($val["item_brief"]) > $widget["settings"]["set_chars"])
					$items[$key]["item_brief"] = substr($val["item_brief"] , 0, $widget["settings"]["set_chars"]) . "[...]"; 

				$items[$key]["date"]	= CDate::ToStr("j M Y" , $val["item_date"]);
				$items[$key]["time"]	= CDate::ToStr("g:i a" , $val["item_date"]);


				$items[$key]["item_stats_comments"] = $this->plugins["comments"]->CommentsCount(
					$widget["mod_settings"]["set_comments"],
					$items[$key]["link"],
					$items[$key]["item_stats_comments"]
				);

				$val["author_link"] = $widget["link"] . "authors/" . $val["author_url"] . "/" ;


				$items[$key]["author"] = $this->tpl->blockReplace($val["author_details"] ? "AuthorLink" : "Author" , $val);

			}
			

			return $this->tpl->blockReplace(
				"Main" , 
				array(
					"widget_title"	=> $widget["widget_name"],
					"news"			=> $base->html->table(
						$this->tpl, 
						"" , 
						$items
					)
				),
				$widget["mod_settings"]
			);
		}

	}
	
}


?>